package pogamutjavabot080430;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddItem;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Armor;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.PogProp;
import java.util.ArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 */
public class Main extends Agent {
    
    public static final int BOT_SKILL = 3;  // Range 1-7 ... 1 is the lowest, 7 the highest.
    public static final double BOT_ACCURACY = 1;    // This doesn't have much effect in the current version of GameBots...
    public static final int BOT_AGRESIVITY = 3;     // Range 1-3 ... 1 is the lowest, 7 the highest.
    
    // Critical weapon constant
    private static final double MinLoadedWeapon = 0.22;
    // Critical health constants
    private static final int MinAgentHealthCriticalValue = 10;
    private static final int MinAgentHealthAndArmo = 25;
    private static final double MinArmoCoeficient = 0.3;
    
    // Item bonus
    private static final double visibledItemBonus = 0.96;
    private static final double ReachableItemBonus = 0.8;
    private static final double MaxNegativeBonus = 3800;
    private static final double MaxHealthBonus = 100;       //  5 .. 233, 25 .. 500, 100 .. 1000
    private static final double MaxArmorBonus = 30;      
    private static final double MaxHasWeaponNegative = 1230;
    private static final double SelectItemDistance = 780;
    
    private MyPathMaker myPathMaker = null;
    
    private ArrayList<Item> knowItems = new ArrayList<Item>();
    
    // I need just unsigned int
    private static final int OnSamePlace = 60;
    private static final int OnSameZPlace = 150;
    private static final int OnSameFightPlace = 150;
    
    // Targets
    private Item targetItem = null;
    private Player targetPlayer = null;
    
    private PickedItemsUpMemory pickedItems = new PickedItemsUpMemory();
    
    private Object logicMutex = new Object();    // synchronizer
    
    // Bot has died
    private DiedListener diedListener = new DiedListener();
    private class DiedListener implements RcvMsgListener
    {
        public DiedListener()
        {
            body.addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
        }
        
        @Override public void receiveMessage(RcvMsgEvent e)
        {
            synchronized (logicMutex)
            {
                targetItem = null;
                targetPlayer = null;
                my_info("I has died!");
            }
        }
    }
    
    // Some one has been killed (another bot)
    private KilledListener killedListener = new KilledListener();
    private class KilledListener implements RcvMsgListener
    {
        public KilledListener()
        {
            body.addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
        }
        
        @Override public void receiveMessage(RcvMsgEvent e)
        {
            synchronized (logicMutex)
            {
                targetPlayer = null;
                targetItem = null;
            }
        }
    }
    
    // Bot has picked something up
    private PickUpListener pickUpListener = new PickUpListener();
    private class PickUpListener implements RcvMsgListener
    {
        public PickUpListener()
        {
            body.addTypedRcvMsgListener(this, MessageType.ADD_WEAPON);
            body.addTypedRcvMsgListener(this, MessageType.ADD_HEALTH);
            body.addTypedRcvMsgListener(this, MessageType.ADD_AMMO);
            body.addTypedRcvMsgListener(this, MessageType.ADD_ARMOR);
            body.addTypedRcvMsgListener(this, MessageType.ADD_EXTRA); 
        }
        
        @Override public void receiveMessage(RcvMsgEvent e)
        {
            synchronized (logicMutex)
            {
                AddItem item = (AddItem)e.getMessage();
                if (item.ID != 0)
                {
                    // this means it is INV message not AIN message
                    pickedItems.addFull(item.ID);
                    my_info("I has picked up: " + item.ID);
                    
                    if (targetItem != null && targetItem.ID == item.ID)
                    {    
                        my_info("I has picked up target! " + targetItem.ID);
                        targetItem = null;
                    }
                }
            }
        }
    }
    
    // Pokud vidim / (slyset nejde) objeveni Itemu, tak ji zase odeber
    // Vidim novou polozku ???? .. neni dobre, protoze kdyz se nekam nemuzu dostat, tak vec zapomenu a potom treba vyskovim a opet ji vidim a tak ji smazi a opet tam bezim
    /*private SeeItemListener seeItemListener = new SeeItemListener();
    private class SeeItemListener implements RcvMsgListener
    {
        public SeeItemListener()
        {
            body.addTypedRcvMsgListener(this, MessageType.ITEM);
        }
        
        @Override public void receiveMessage(RcvMsgEvent e)
        {
            synchronized (logicMutex)
            {               
                Item item = (Item)e.getMessage();
                if (item.ID != 0)
                    if (pickedItems.remove(item.ID) != null)
                        my_info("I see forgot item! " + item.ID);
            }
        }
    }*/
    
    public enum Ray {
        
        STRAIGHT_AHEAD(1, new Triple(1, 0, 0), 300),
        BACK(2, new Triple(-1, 0, 0), 300),
        LEFT(3, new Triple(0, 1, 0), 300),
        RIGHT(4, new Triple(0, -1, 0), 300);
        
        private int id;
        private Triple vector;
        private double length;
        
        private Ray(int id, Triple vector, double length) {
            this.id = id;
            this.vector = vector;
            this.length = length;
        }
        
        public int getId() {
            return id;
        }
        
        public Triple getVector() {
            return vector;
        }
        
        public double getLength() {
            return length;
        }
    }
    
    private RayTraces traces = new RayTraces();
    private class RayTraces implements RcvMsgListener {
        
        /**
         * Here we will store the last results of raycastings.
         * 
         *  Ray's ID -> result
         * (Integer  -> AutoTraceRay)
         */
        private Map<Integer, AutoTraceRay> traces = new HashMap<Integer, AutoTraceRay>();
        
        public RayTraces() {}
        
        /**
         * This method will be called from doLogic() only once to initialize the object.
         */
        public void botInit() {
            log.info("RayTraces.botInit(): called");
            
            // tells the GameBots we want autotracing
            body.startAutoTrace();
            
            // remove default auto trace rays
            body.removeAllRaysFromAutoTrace();
            
            // now 1) register every ray inside GameBots and
            //     2) create initial value for every ray
            for (Ray ray : Ray.values()) {
                body.addRayToAutoTrace(ray.getId(), ray.getVector(), ray.getLength(), 
                                       false, // whether this is FastTrace ... NO we want full trace
                                              // to get HitNormal informations
                                       false  // whether we should trace the players and helaths as well
                                              // NO ... we want only walls, floors, etc.
                                      );
                traces.put(ray.getId(), new AutoTraceRay());
            }
            
            // register itself as a listener for ATR messages, so 
            // we can catch the AUTO_TRACE_RAY
            body.addTypedRcvMsgListener(this, MessageType.AUTO_TRACE_RAY);
            
            // now a little workarounds ...
            
            // we have to move a bot a bit to get first readings from rays
            body.moveInch();
            
            // now, to see only new rays (not the default ones), we have to switch
            // visibility of autotraces off and on again (with little delay)
            body.configureAutoTrace(false);
            try {
                Thread.sleep(200);
            } catch (InterruptedException ex) {               
            }
            body.configureAutoTrace(true);

        }

        /**
         * In this method we're receiving notices about ATR messages. It's
         * called every time when ATR message arrives.
         * @param e
         */
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            // get the message from the event (casting it properly)
            AutoTraceRay ray = (AutoTraceRay)e.getMessage();
            try {
                // be synchronized with 'traces' to prevent concurrent read/write operations
                synchronized(traces) {
                    // insert the ray under it's number
                    // notice that ID goes under UnrealID field in the 'ray'
                    traces.put(Integer.parseInt(ray.UnrealID), ray);
                }
            } catch (Exception ex) {
                log.severe(ex.getMessage());
            }
        }
        
        //
        // now follows methods for getting the traces out of the object
        // 
        
        /**
         * Returns info about one ray.
         * @param ray
         * @return
         */
        public AutoTraceRay getTrace(Ray ray) {
            synchronized(traces) {
                return traces.get(ray.getId());
            }            
        }
        
        /**
         * Returns the copy of the map of traces.
         * 
         * This will be useful for you when you will program the
         * control mechanism of the bot. You shouldn't rely on the getTrace()
         * because two calls of it may return different result (because of 
         * a two thread design of the bot).
         * 
         * @return current state of traces
         */
        public Map<Integer, AutoTraceRay> getTraceSnapshot() {
            synchronized(traces) {
                return new HashMap<Integer, AutoTraceRay>(traces);
            }
        }
        
    }

    /** Creates a new instance of agent. */
    public Main() {
    }
    
    private void my_info(String text)
    {
        body.sendGlobalMessage(text);
        log.info(text);
    }
    
    @PogProp public double score = 0;

    @Override protected void doLogic() {
        score = memory.getAgentScore();
        synchronized (logicMutex)
        {       
            pickedItems.doForgetItems();
            
            // Vidim na misto nebo sem blizko, kam bezim, ale nekdo to uz sebral prede mnou
            if (targetItemIsNegative())
            {
                pickedItems.addHalf(targetItem.ID);
                targetItem = null;
            }
            
            if (!doMinimumWeaponLogic())        // Zajisti, abych mel alespon 1 castecne nabitou zbran
                if (!doMinimumHealthAndArmoLogic())
                {
                    // Vyberu hrace na ktereho budu utocit
                    Player enemy = selectEnemy();
                    if (enemy != null)
                        targetPlayer = enemy;
                    
                    if (targetPlayer != null)
                        if (Triple.distanceInSpace(targetPlayer.location, memory.getAgentLocation()) < OnSameFightPlace)
                            targetPlayer = null;
                    
                    if (targetPlayer != null)
                    {
                        targetItem = null;
                        
                        if (memory.getSeeAnyEnemy())
                            doFightMove();      // Uhyby atd.
                        else
                        {
                            if (!myPathMaker.runToTarget(targetPlayer.location))
                            {
                                my_info("I can\'t get to last target player location!");
                                body.turnHorizontal(90);
                                targetPlayer = null;
                            }
                        }
                    }
                    else
                    {
                        // Sbiram veci
                        if (targetItem == null)
                        {
                            selectItemFromList(memory.getSeeAmmos(), selectItemFromList(memory.getSeeArmors(), selectItemFromList(memory.getSeeHealths(), selectItemFromList(memory.getSeeWeapons(), Double.MAX_VALUE))));
                            if (targetItem == null)
                                selectItemFromList(knowItems, Double.MAX_VALUE);
                            
                            if (targetItem == null)
                                 my_info("There is no any  usedfull ITEM !!!");
                            else
                                my_info("I choose this ITEM: " + targetItem.toString());
                        }
                        
                        if (targetItem != null)
                        {
                            if (!myPathMaker.runToTarget(targetItem.location))
                            {
                                my_info("I can\'t get to ITEM location! " + targetItem.ID);
                                pickedItems.addTwice(targetItem.ID);
                                targetItem = null;
                            }
                        }
                    }
                            
                    doFireLogicByAggerivity(1);
                }
        }
    }
    
    // Vidim na misto nebo sem blizko, kam bezim, ale nekdo to uz sebral prede mnou
    // CHYBI DODELAT, ZE Na MISTO VIDIM, ALE JE SEBRANE !!!
    private boolean targetItemIsNegative()
    {
        if (targetItem == null)
            return false;
        
        // Agent dosel na misto treba pozadu
        if (Triple.distanceInSpace(memory.getAgentLocation(), targetItem.location) <= OnSamePlace)
            return true;
        
        if (targetItem.navPoint == null)
            return false;
        
        // Vidim na navigacni bod, ale nevidim tam tu vec, co chci
        NavPoint np = memory.getSeeNavPoint(targetItem.navPoint.ID);
        if (np != null && np.visible && memory.getSeeItem(targetItem.ID) == null)               
        {
            my_info("I see target nav point but i don\'t see the item: " + targetItem.ID);
            return true;
        }
                
        return false;
    }
    
    // Zajisti, abych mel alespon 1 castecne nabitou zbran
    private boolean doMinimumWeaponLogic()
    {       
        if (!hasMinimumWeaponAndAmmo())
        {
            // Select the nearest weapon or ammo
            if (targetItem == null)
            {
                // Select and save the best weapon or ammo pack
                targetItem = memory.getSeeWeapon();
                if (targetItem == null)
                    selectItemFromList(memory.getKnownWeapons(), selectItemFromList(memory.getSeeAmmos(), Double.MAX_VALUE));
                
                if (targetItem == null)
                {
                     my_info("There is no any  usedfull WEAPON/AMMO !!!");
                    return false;
                }
                else
                    my_info("I choose this WEAPON/AMMO: " + targetItem.toString());
            }
            
            if (targetItem != null)
            {
                if (myPathMaker.runToTarget(targetItem.location))
                {
                    doFireLogicByAggerivity(3);
                    return true;
                }
                else
                {
                    my_info("I can\'t get to WEAPON/AMMO location! " + targetItem.ID);
                    pickedItems.addTwice(targetItem.ID);
                    targetItem = null;
                }
            }
        }
        
        return false;
    }
    
    private boolean hasMinimumWeaponAndAmmo()
    {
        double minNumber = 0;
        for (AddWeapon weapon : memory.getCopyOfAllWeapons())
            if (weapon.getWeaponType() != ItemType.SHIELD_GUN && weapon.getWeaponType() != ItemType.ASSAULT_RIFLE)      // Translocator is not tested (This type doesn't exist) !!!
                minNumber += (double)weapon.currentAmmo / weapon.maxAmmo;
        
        return minNumber >= MinLoadedWeapon;
    }
    
    private double selectItemFromList(ArrayList<? extends Item> items, double distance)
    {
        for (Item item : items)
            if (!pickedItems.contains(item.ID))
            {
                double d = Triple.distanceInSpace(memory.getAgentLocation(), item.location);

                // General bonus
                if (item.isVisible())
                    d *= visibledItemBonus;
                if (item.isReachable())
                    d *= ReachableItemBonus;

                // Specific bonus
                if (item instanceof Weapon)
                {
                    Weapon weapon = (Weapon)item;
                    if (weapon.getWeaponType() == ItemType.SHIELD_GUN || weapon.getWeaponType() == ItemType.ASSAULT_RIFLE)
                        d += MaxNegativeBonus;
                        d += memory.hasWeaponOfType(weapon.getWeaponType()) ? MaxHasWeaponNegative : -MaxHasWeaponNegative;
                }

                if (item instanceof Ammo)
                    if (memory.hasWeaponOfType(((Ammo)item).getAmmoType()))
                    {
                        AddWeapon playerWeapon = getPlayerWeapon(((Ammo)item).getAmmoType());
                        d += Math.max(0.0, (1.0 - ((double)playerWeapon.maxAmmo - playerWeapon.currentAmmo) / ((Ammo)item).ammoAmount)) * MaxNegativeBonus;
                    }
                    else
                        d += MaxNegativeBonus;

                 if (item instanceof Health)
                 {
                     Health healt = (Health)item;
                     double maxHealt = healt.boostable ? 199 : 100;
                     if (memory.getAgentHealth() >= maxHealt)
                         d += MaxNegativeBonus;
                     else
                         d -= (double)Math.sqrt(Math.min(maxHealt - memory.getAgentHealth(), healt.strength)) * MaxHealthBonus;
                 }

                if (item instanceof Armor)
                {
                    Armor armor = (Armor)item;
                    double maxArmor = armor.strenght == 100 ? 150 : 50;
                    if (memory.getAgentArmor() >= maxArmor)
                        d += MaxNegativeBonus;
                     else
                        d -= (double)Math.sqrt(Math.min(maxArmor - memory.getAgentArmor(), armor.strenght)) * MaxArmorBonus;
                }

                if (d < distance)
                {
                    targetItem = item;
                    distance = d;
                }
            }
        
        return distance;
    }
    
    private AddWeapon getPlayerWeapon(ItemType weaponType)
    {
        for (AddWeapon weapon : memory.getCopyOfAllWeapons())
            if (weapon.getWeaponType() == weaponType)
                return weapon;
            
        return null;
    }
    
    private boolean doMinimumHealthAndArmoLogic()
    {
        if (!hasMinimumHealthAndArmo())
        {
            // Select the nearest health
            if (targetItem == null)
            {
                targetItem = null;
                // Select and save the best health pack
                selectItemFromList(memory.getSeeItems(), Double.MAX_VALUE);
                if (targetItem == null)
                    selectItemFromList(memory.getKnownHealths(), Double.MAX_VALUE);
                
                if (targetItem == null)
                {
                    my_info("There is no any  usedfull HEALTH !!!");
                    return false;
                }
                else
                    my_info("I choose this HEALTH: " + targetItem.toString());
            }
            
            if (targetItem != null)
            {
                if (myPathMaker.runToTarget(targetItem.location))
                {
                    doFireLogicByAggerivity(2);
                    return true;
                }
                else
                {
                    my_info("I can\'t get to HEALTH location! " + targetItem.ID);
                    pickedItems.addTwice(targetItem.ID);
                    targetItem = null;
                }
            }
        }
        
        return false;
    }
    
    private boolean hasMinimumHealthAndArmo()
    {
        if (memory.getAgentHealth() < MinAgentHealthCriticalValue)
            return false;
        
        return (memory.getAgentHealth() + memory.getAgentArmor() * MinArmoCoeficient) > MinAgentHealthAndArmo;
    }
    
    private void doFireLogicByAggerivity(int aggresivityState)
    {
        if (aggresivityState > BOT_AGRESIVITY)
            return;
        
        doSwitchToTheBestCurrentWeapon();
        doFireToTargetPlayer();
    }
    
    private void doSwitchToTheBestCurrentWeapon()
    {
        if (targetPlayer != null)
        {
            ArrayList<ItemType> perferedWeapons = new ArrayList<ItemType>();
            
            // nepritel je nize
            if (targetPlayer.location.z > memory.getAgentLocation().z + OnSameZPlace)
            {
                perferedWeapons.add(ItemType.ROCKET_LAUNCHER);
                perferedWeapons.add(ItemType.FLAK_CANNON);
                perferedWeapons.add(ItemType.BIO_RIFLE);
            }
            
            if (doSwitchWeaponByPrefered(perferedWeapons))
                return;
            
            // nepritel je vyz
            if (targetPlayer.location.z < memory.getAgentLocation().z - OnSameZPlace)
            {
                perferedWeapons.clear();
                perferedWeapons.add(ItemType.FLAK_CANNON);
                perferedWeapons.add(ItemType.BIO_RIFLE);
            }
            
            if (doSwitchWeaponByPrefered(perferedWeapons))
                return;
            
            body.changeToBestWeapon();
        }
    }
    
    private boolean doSwitchWeaponByPrefered(ArrayList<ItemType> perferedWeapons)
    {
        for (ItemType weaponType : perferedWeapons)
            if (memory.hasWeaponOfType(weaponType))
            {
                AddWeapon weapon = getPlayerWeapon(weaponType);
                if (weapon != null && weapon.currentAmmo > 0)
                {
                    body.changeWeapon(weapon);
                    return true;
                }
            }
        
        return false;
    }
            
     
    private void doFireToTargetPlayer()
    {
        if (targetPlayer != null && memory.getSeeAnyEnemy())
            if (memory.getCurrentWeapon().getWeaponType() == ItemType.FLAK_CANNON && targetPlayer.location.z <= memory.getAgentLocation().z - OnSameZPlace)
                if (memory.getCurrentWeapon().getWeaponType() == ItemType.ROCKET_LAUNCHER)
                {
                    Triple trip = (Triple)targetPlayer.location.clone();
                    trip.z += OnSamePlace;
                            
                    body.shoot(trip);
                }
                else
                    body.shootAlternate(targetPlayer);
            else
                body.shoot(targetPlayer);
    }
    
    private Player selectEnemy()
    {
        // pokud vidim stareho protihrace, tak to vyberu
        if (targetPlayer != null && memory.getSeePlayer(targetPlayer.ID) != null)
                return targetPlayer;
        
        return memory.getSeeEnemy();
    }
    
    private void doFightMove()
    {
        if (targetPlayer != null && memory.getSeeAnyEnemy())
        {
            // get current snapshot of rays
            Map<Integer, AutoTraceRay> rays = traces.getTraceSnapshot();
           
            ArrayList<Triple> dodges = new ArrayList<Triple>();
            if (rays.get(Ray.STRAIGHT_AHEAD.getId()).result)
                dodges.add(Ray.STRAIGHT_AHEAD.getVector());
            if (rays.get(Ray.BACK.getId()).result)
                dodges.add(Ray.BACK.getVector());
            if (rays.get(Ray.LEFT.getId()).result)
                dodges.add(Ray.LEFT.getVector());
            if (rays.get(Ray.RIGHT.getId()).result)
                dodges.add(Ray.RIGHT.getVector());
            
            if (dodges.size() > 0)
                body.dodge(dodges.get((int)(Math.random() * (dodges.size() - 1))));
            else
                if (!gameMap.safeRunToPlayer(targetPlayer))
                    body.turnToLocation(targetPlayer.location);
        }
    }

    @Override protected void prePrepareAgent() throws PogamutException {
    /* Prepares agent logic to run - like initializing neural networks etc.
    not for establishing communication! */

    }

    @Override protected void postPrepareAgent() throws PogamutException {
    /* Prepare logic according to information from gathered from startCommunication
    like choosing plan/parameters according to game type. */
        body.initializer.setBotSkillLevel(BOT_SKILL);
        body.initializer.setAccuracy(BOT_ACCURACY);
        
        myPathMaker = new MyPathMaker(gameMap, memory, body);
        
        traces.botInit();
        
        for (Weapon weapon : memory.getKnownWeapons())
            knowItems.add(weapon);
        for (Health health : memory.getKnownHealths())
            knowItems.add(health);
    }

    @Override protected void shutdownAgent() throws PogamutException {
    // Clean up after the end of simulation of agent

    }

    public static void main(String[] args) {
    /*
    DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
    BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
    NETBEANS BY A CUSTOM ANT TASK (see build.xml).
     */
    }
}